
markup.push(
{

// MARK: trial bar

TrialBarView:
{
	nsClass: "GXExpandingView",
	gxViewName: "trialBar",
	gxCollapsedSize: 0,
	gxDefaultValue: false,	// collapsed
	gxIntrinsicWidth: -1,
	gxChildViews:
	{
		"trialBarContent" :
		{
			// the entire contents of the trialbar are placed inside a view
			// that isn't resized vertically, so it draws only once when the bar animates
			nsClass: "GXDrawView",
            axIsIgnored: false,
            axTitle: "Trial mode information bar",
			gxAnimationDivider: 8,
			gxIntrinsicWidth: -1,
			gxBackPainter: {
				"+": "TrialFillPainter",
			},
			gxLayout: [
				"V:|-0-[self(40)]",
				"H:|-0-[self]-0-|",
				"V:|-2-[trialText]-2-|",
				"V:|-8-[trialBtn(24)]",
				"H:|-12-[trialText]-5-[trialBtn(84)]-12-|",
			],
			gxChildViews:
			{
				"trialText":
				{
					nsClass: "GXLabelView",
					gxIntrinsicWidth: -1,
					gxHideOnNil: true,
					axIsIgnored: false,
					gxFormatter: "TrialTextFormatter",
					gxForePainter: "LabelFore.useMarkup.foreColorTheme1.left.centery.wrap.size13",
				},
				"trialBtn":
				{
					nsClass: "GXButtonView",
					gxHideOnNil: true,
					gxTitle: "Details...",
					axTitle: "Trial Details",
					gxForePainter: "LabelFore.foreColorTheme1.centerx.centery.wrap.size13",
					gxBackPainter: {
						"+": "ControlBack",
						gxFillColor: colorMono(0, 22),
						//gxFrameColor: colorMono(0, 15),
						"pressed": {
							gxFillColor: colorMono(0, 32),
							//gxFrameColor: colorMono(0, 25),
						}
					},
				},
			},
		},
	},
},


// MARK: descriptions

TrialTextFormatter:
{
	nsClass: "GXDictionaryFormatter",
	gxDictionary: {
		0: "You are using Audio Hijack in trial mode.",
		1: "\u26A0\uFE0F Please purchase Audio Hijack.",
		
		10: "You are using Audio Hijack in trial mode. Noise will be overlaid on captured audio after 10 minutes.",
		11: "\u26A0\uFE0F Audio Hijack's trial limitations have been activated. Please purchase Audio Hijack.",
		
		20: "Audio Hijack is in trial mode. Noise will be overlaid on captured audio after 10 minutes.",
		21: "\u26A0\uFE0F Audio Hijack's trial limitations have been activated. <boldWeight>Noise is now being overlaid.</boldWeight> Please purchase Audio Hijack.",
	},
},

})
